# 💰 ScoreInvest Portfolio Tracker v2.0 PREMIUM

> **Suivez votre patrimoine comme un pro, en toute confidentialité**

![Version](https://img.shields.io/badge/version-2.0-gold)
![Python](https://img.shields.io/badge/python-3.10+-blue)
![Platform](https://img.shields.io/badge/platform-Windows%20|%20Mac%20|%20Linux-green)

---

## 🆕 Nouveautés v2.0

| Fonctionnalité | Description |
|----------------|-------------|
| 📈 **Actualisation auto** | Cours en temps réel via Yahoo Finance + CoinGecko |
| 🌓 **Thèmes** | Mode sombre et clair |
| 📊 **Graphiques améliorés** | Courbes avec aires, allocation vs cible |
| 💰 **Dividendes** | Suivi complet des revenus passifs |
| 📅 **Transactions** | Historique détaillé de tous vos mouvements |
| 🎯 **Allocation cible** | Comparaison allocation réelle vs objectifs |
| 💾 **Backup/Restore** | Sauvegarde et restauration faciles |
| 🔔 **Alertes** | Notifications sur seuils de prix |

---

## ✨ Fonctionnalités complètes

### 📊 Dashboard
- Vue d'ensemble patrimoine avec 5 indicateurs clés
- Graphique d'évolution avec aire sous la courbe
- Répartition par catégorie (pie chart)
- Top 5 positions avec performance
- Comparaison allocation réelle vs cible
- Sélection de période (30j, 90j, 6m, 1an, tout)

### 💼 Portefeuille
- Gestion complète des actifs (CRUD)
- 9 catégories : Actions, ETF, Obligations, Crypto, Immobilier, Fonds Euro, SCPI, Liquidités, Autre
- Filtres par catégorie + recherche
- Import/Export CSV multi-formats
- Menu contextuel avec actions rapides
- Actualisation automatique des cours

### 📈 Actualisation des cours
- **Yahoo Finance** : Actions, ETF, indices
- **CoinGecko** : Cryptomonnaies (BTC, ETH, SOL...)
- Mise à jour en arrière-plan (non bloquant)
- Option d'activer/désactiver par actif

### 💰 Dividendes
- Enregistrement des dividendes reçus
- Retenue à la source
- Total par année
- Intégré au calcul de performance

### 🎯 Objectifs
- Création d'objectifs personnalisés
- Barre de progression visuelle
- Date cible optionnelle
- Priorité et couleurs personnalisables

### ⚙️ Paramètres
- Choix du thème (sombre/clair)
- Export sauvegarde complète
- Import sauvegarde
- Réinitialisation données
- Informations système

---

## 🎨 Interface

### Thème Sombre (par défaut)
- Fond : #0a0a0f (noir profond)
- Cartes : #12121a
- Accent : #d4af37 (or)
- Succès : #10b981 (vert)
- Danger : #ef4444 (rouge)

### Thème Clair
- Fond : #f8f9fa
- Cartes : #ffffff
- Accent : #b8860b (or foncé)

---

## 📥 Installation

### Option 1 : Exécutable (recommandé)
```
Téléchargez ScoreInvestPortfolio.exe et double-cliquez
```

### Option 2 : Python
```bash
pip install PyQt6 PyQt6-Charts
python ScoreInvestPortfolio.py
```

### Option 3 : Compiler
```bash
pip install pyinstaller
pyinstaller --onefile --windowed --name "ScoreInvest Portfolio v2" ScoreInvestPortfolio.py
```

---

## 📊 APIs utilisées

| API | Usage | Limites |
|-----|-------|---------|
| Yahoo Finance | Actions, ETF | Gratuit, pas de clé |
| CoinGecko | Crypto | Gratuit, 10-50 req/min |

### Tickers supportés

**Yahoo Finance** (ajout automatique de .PA pour Paris) :
- `AAPL`, `MSFT`, `GOOGL` (US)
- `CW8`, `EWLD`, `LQQ` (Euronext Paris)
- `^FCHI` (CAC40), `^GSPC` (S&P500)

**CoinGecko** :
- `BTC`, `ETH`, `SOL`, `ADA`, `DOT`, `AVAX`, `MATIC`, `LINK`, `UNI`, `XRP`, `DOGE`, `SHIB`

---

## 💾 Stockage des données

```
Windows: C:\Users\[Vous]\.scoreinvest_tracker\portfolio_v2.db
Mac:     /Users/[Vous]/.scoreinvest_tracker/portfolio_v2.db
Linux:   /home/[vous]/.scoreinvest_tracker/portfolio_v2.db
```

### Structure base de données

| Table | Description |
|-------|-------------|
| `assets` | Actifs avec prix, quantité, catégorie |
| `transactions` | Achats/ventes avec frais |
| `dividends` | Dividendes reçus |
| `portfolio_history` | Snapshots quotidiens |
| `goals` | Objectifs patrimoniaux |
| `target_allocation` | Allocation cible par catégorie |
| `alerts` | Alertes de prix |
| `watchlist` | Actifs surveillés |
| `settings` | Paramètres utilisateur |

---

## 🔒 Confidentialité

✅ **100% local** - Aucun compte, aucune inscription  
✅ **Aucune donnée envoyée** - Seuls les cours sont récupérés  
✅ **Open source** - Code vérifiable  
✅ **Backup chiffré** - Vous contrôlez vos sauvegardes  

---

## 📝 Changelog

### v2.0.0 (Février 2026)
- 🎨 Nouveau design avec thèmes clair/sombre
- 📈 Actualisation automatique des cours (Yahoo Finance + CoinGecko)
- 💰 Suivi des dividendes
- 📅 Historique des transactions
- 🎯 Allocation cible avec comparaison
- 💾 Backup/Restore
- 📊 Graphiques améliorés avec aires
- 🔧 Refonte complète de la base de données

### v1.0.0 (Février 2026)
- Version initiale

---

## 🛠️ Développement

```bash
# Cloner
git clone https://github.com/scoreinvest/portfolio-tracker.git

# Dépendances
pip install PyQt6 PyQt6-Charts

# Lancer
python ScoreInvestPortfolio.py

# Tests
python -m pytest tests/
```

---

## 📞 Support

- 🌐 **Site** : [scoreinvest.fr](https://scoreinvest.fr)
- 📧 **Email** : contact@scoreinvest.fr
- 📚 **Guide** : [scoreinvest.fr/guide-investissement](https://scoreinvest.fr/guide-investissement)

---

**© 2026 ScoreInvest.fr - TENDIL COURTAGE (ORIAS n°26000195)**  
*Le GPS de votre patrimoine* 🧭
